// PageSettingCuster.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingSIP.h"
#include "Include\CommonFun.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "DecCtrlClientTypes.h"

// CPageSettingSIP Ի

IMPLEMENT_DYNAMIC(CPageSettingSIP, CDialog)

CPageSettingSIP::CPageSettingSIP(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingSIP::IDD, pParent)
{

}

CPageSettingSIP::~CPageSettingSIP()
{
}

void CPageSettingSIP::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB6, m_TabCuster);
}


BEGIN_MESSAGE_MAP(CPageSettingSIP, CDialog)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB6, &CPageSettingSIP::OnTcnSelchangeTab6)
END_MESSAGE_MAP()


// CPageSettingSIP Ϣ
int CPageSettingSIP::Initialize(LONG _lLogonID)
{
	if (_lLogonID < 0)
	{
		return -1;
	}
	m_lLogonID = _lLogonID;
	m_pageSipAndPlatform.SetLogonID(_lLogonID);
	m_pageSipEx.SetLogonID(_lLogonID);

	memset(&m_decParam,0,sizeof(m_decParam));
	DEC_ClientGetDecoderPara(_lLogonID,&m_decParam);

	m_pageSipAndPlatform.Initialize(&m_decParam);
	m_pageSipEx.Initialize();

	return 0;
}
BOOL CPageSettingSIP::OnInitDialog()
{
	CDialog::OnInitDialog();
	m_TabCuster.InsertItem(0, GetTextByLan("SIP/ƽ̨","SIP/PlatForm"));
	m_TabCuster.InsertItem(1, "SIPChannel");

	m_pageSipAndPlatform.Create(IDD_DIALOG_PAGE_SETTINGSIPANDPLATFORM, &m_TabCuster);
	m_pageSipEx.Create(IDD_DIALOG_PAGE_SETTINGSIPEX, &m_TabCuster);

	CRect rc;
	m_TabCuster.GetClientRect(rc);
	rc.top += 21;
	rc.bottom -= 5;
	rc.left += 3;
	rc.right -= 5;

	m_pageSipAndPlatform.MoveWindow(&rc);
	m_pageSipEx.MoveWindow(&rc);

	m_pDialog[0] = &m_pageSipAndPlatform;
	m_pDialog[1] = &m_pageSipEx;

	m_pDialog[0]->ShowWindow(SW_SHOW);
	m_pDialog[1]->ShowWindow(SW_HIDE);
	this->SetWindowText(GetText(IDS_SETTING_SET));
	//浱ǰѡ
	m_iCurSelTab = 0;
	return FALSE;
}


void CPageSettingSIP::OnTcnSelchangeTab6(NMHDR *pNMHDR, LRESULT *pResult)
{
	m_pDialog[m_iCurSelTab]->ShowWindow(SW_HIDE);
	m_iCurSelTab = m_TabCuster.GetCurSel();
	m_pDialog[m_iCurSelTab]->ShowWindow(SW_SHOW);
	*pResult = 0;
}

void CPageSettingSIP::OnMainNotify( _MAIN_NOTIFY_DATA* _pData )
{
	
}
